﻿var importSample = {
    datatable: null,
    refreshDataTable: function () {
        importSample.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-importSampleTable").a4datatable({
            ajaxAction: a4.getSurveyAction("GetImportSamples", "Distribute"),
            columns: [
                { "Data": "Message", "Tooltip": true },
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false },
                { "Name": "Name", "Title": resources.Name, "Data": "Name" },
                { "Name": "Status", "Title": resources.Status, "Data": "StatusEnum" },
                { "Name": "Progression", "Title": resources.Progression, "Data": "Progression", "Visible": false },
                { "Name": "Description", "Title": resources.Description, "Data": "Description", "Visible": false },
                { "Name": "DataSourceType", "Title": resources.DataSourceType, "Data": "DataSourceType" },
                { "Name": "CaseCount", "Title": resources.CaseCount, "Data": "CaseCount", "Sortable": false },
                { "Name": "FileName", "Title": resources.FileName, "Data": "FileName" },
                { "Name": "CreationDate", "Title": resources.CreationDate, "Data": "CreationDate" },
                { "Name": "LastExecutionDate", "Title": resources.LastExecutionDate, "Data": "LastExecutionDate", "Visible": false },
                { "Name": "ScheduleDate", "Title": resources.NextRun, "Data": "ScheduleDate", "Visible": false },
                { "Name": "ScheduleType", "Title": resources.ScheduleType, "Data": "ScheduleTypeLabel", "Visible": false }
            ],
            localizableTexts: { "Search": resources.SearchImportSamples },
            defaultSorting: { Column: "CreationDate", Ascending: false },
            toolBarItems: importSample.getToolBarItems(),
            stateKey: "ImportSample",
            autoUpdate: true,
            contextMenuItems: importSample.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                switch (action) {
                    case "delete":
                        importSample.deleteItems(ids);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "stop":
                        importSample.stopTask(row.Id);
                        break;
                    case "delete":
                        importSample.deleteTask(row.Id);
                        break;
                    case "deleteAndRemoveCases":
                        importSample.deleteTaskAndRemoveCases(row.Id);
                        break;
                    case "execute":
                        importSample.executeTask(row.Id);
                        break;
                    case "copy":
                        importSample.copyTask(row.Id);
                        break;
                    case "view":
                        importSample.viewTask(row.Id);
                        break;
                    case "edit":
                        importSample.editTask(row.Id);
                        break;
                    case "editSchedule":
                        modalDialog.showWindow(a4.getAction("ImportScheduleEditor", "Shared", "Home", { surveyId: a4.getSurveyId(), importId: row.Id }), 720, 1200, { focusFirstField: false });
                        break;
                    case "history":
                        modalDialog.showWindow(a4.getSurveyAction("ImportSampleHistory", "Distribute", { importId: row.Id, name: row.Name }), 700, 950);
                        break;
                }
            }
        });
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteImportationsResources, function () {
            a4.callServerMethod(a4.getSurveyAction("DeleteImportSampleTasks", "Distribute"), { taskIds: items },
            function (result) {
                importSample.refreshDataTable();
            });
        }, 250, 500, true, { "count": itemsCount });
    },
    viewTask: function (itemId) {
        modalDialog.showWindow(a4.getSurveyAction("ImportSampleWizard", "Distribute", { importationId: itemId, readOnly: true }), 700, 950);
    },
    editTask: function (itemId) {
        modalDialog.showWindow(a4.getSurveyAction("ImportSampleWizard", "Distribute", { importationId: itemId, edit: true }), 700, 950);
    },
    copyTask: function (itemId) {
        modalDialog.showWindow(a4.getSurveyAction("ImportSampleWizard", "Distribute", { importationId: itemId }), 700, 950);
    },
    stopTask: function (itemId) {
        a4.callServerMethod(a4.getSurveyAction("StopImportSampleTask", "Distribute"), { taskId: itemId }, function (result) {
            importSample.refreshDataTable();
        });
    },
    deleteTask: function (itemId) {
        modalDialog.showConfirmDialog(confirmDeleteImportationsResources, function () {
            a4.callServerMethod(a4.getSurveyAction("DeleteImportSampleTask", "Distribute"), { taskId: itemId },
            function (result) {
                importSample.refreshDataTable();
            });
        }, 250, 500, true, { "count": 1 });
    },
    deleteTaskAndRemoveCases: function (itemId) {
        modalDialog.showConfirmDialog(confirmDeleteImportationsResources, function () {
            a4.callServerMethod(a4.getSurveyAction("DeleteImportSampleTaskAndCases", "Distribute"), { taskId: itemId },
            function (result) {
                importSample.refreshDataTable();
            });
        }, 250, 500, true, { "count": 1 });
    },
    executeTask: function (itemId) {
        a4.callServerMethod(a4.getSurveyAction("ExecuteImportSampleTask", "Distribute"), { taskId: itemId }, function (result) {
            importSample.refreshDataTable();
        });
    },
    bindEvents: function () {
        $(".h-newImportation").on("click", function () {
            var type = $(this).attr("data-type");
            modalDialog.showWindow(a4.getSurveyAction("ImportSampleWizard", "Distribute", { format: type }), 700, 950);
        });
    },
    getContextMenuItems: function () {
        var notRunningNotCompleted = function (data) { return data.Status != 'Running' && data.Status != 'Completed'; };
        return [
            {
                "Action": "editSchedule", "Label": resources.EditSchedule,
                "DisplayCondition": function (data) {
                    return  data.Status != 'Running' && data.Status != 'Pending'
                            && data.HasFileName == true && data.DataSourceType != 'Archive';
                }
            },
            { "Divider": true },
            { "Action": "copy", "Label": resources.Copy },
            { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.Status != 'Running'; }},
            {
                "Action": "deleteAndRemoveCases", "Label": resources.DeleteAndRemoveCases,
                "DisplayCondition": function (data) {
                    return data.Status != 'Running' && data.DataSourceType != 'Archive' && data.CaseCount > 0;
                }
            },
            { "Action": "edit", "Label": resources.Properties, "DisplayCondition": notRunningNotCompleted },
            {
                "Action": "view", "Label": resources.Properties,
                "DisplayCondition": function (data) { return data.Status == 'Running' || data.Status == 'Completed'; }
            },
            { "Divider": true },
            {
                "Action": "stop", "Label": resources.Stop,
                "DisplayCondition": function (data) { return data.Status == 'Pending' || data.Status == 'Running'; }
            },
            { "Action": "execute", "Label": resources.Execute, "DisplayCondition": notRunningNotCompleted },
            { "Action": "history", "Label": resources.History },
        ];
    },
    getToolBarItems: function () {
        if (canModify) return [{ "Action": "delete", "Label": resources.Delete }];
        else return [];
    }
}

$(document).ready(function () {
    if ($("#importSampleContainer").length > 0) {
        importSample.initializeDataTable();
        importSample.bindEvents();
    }
});